<?php

/*
|--------------------------------------------------------------------------
| Validation Language Lines
|--------------------------------------------------------------------------
|
| The following language lines contain the default error messages used by
| the validator class. Some of these rules have multiple versions such
| as the size rules. Feel free to tweak each of these messages here.
|
*/

return [
    'accepted'             => 'त्या फिल्डला स्वीकारली पाहिजे.',
    'accepted_if'          => ':other हे :value असेल तेव्हा हे फील्ड स्वीकारणे आवश्यक आहे.',
    'active_url'           => 'हे वैध युआरएल नाही.',
    'after'                => 'या :date नंतर तारीख असणे आवश्यक आहे.',
    'after_or_equal'       => 'या नंतर किंवा समान एक तारीख असणे आवश्यक आहे :date.',
    'alpha'                => 'हे फील्ड केवळ अक्षरे असू शकतात.',
    'alpha_dash'           => 'हे फील्ड केवळ अक्षरे असू शकतात, अंक, डॅश आणि अंडरस्कोरसोर.',
    'alpha_num'            => 'हे फील्ड केवळ अक्षरे आणि क्रमांक असू शकतात.',
    'array'                => 'अरे असणे आवश्यक आहे.',
    'before'               => 'या :date आधी एक तारीख असणे आवश्यक आहे.',
    'before_or_equal'      => 'या आधी एक तारीख किंवा :date समान असणे आवश्यक आहे.',
    'between'              => [
        'array'   => 'या सामग्रीमध्ये :min ते :max आयटम असणे आवश्यक आहे.',
        'file'    => 'ही फाइल :min आणि :max किलोबाइट्स दरम्यान असणे आवश्यक आहे.',
        'numeric' => 'हे मूल्य :min ते :max दरम्यान असणे आवश्यक आहे.',
        'string'  => 'स्ट्रिंग :min ते :max वर्णांदरम्यान असणे आवश्यक आहे.',
    ],
    'boolean'              => 'या क्षेत्रात खरे किंवा खोटे असणे आवश्यक आहे.',
    'confirmed'            => 'पुष्टीकरण जुळत नाही.',
    'current_password'     => 'संकेतशब्द चुकीचा आहे.',
    'date'                 => 'ही एक वैध तारीख नाही.',
    'date_equals'          => 'या :date समान तारीख असणे आवश्यक आहे.',
    'date_format'          => 'या स्वरूपात जुळत नाही :format.',
    'declined'             => 'This value must be declined.',
    'declined_if'          => 'This value must be declined when :other is :value.',
    'different'            => 'हे मूल्य विविध असणे आवश्यक आहे :other.',
    'digits'               => 'या असणे आवश्यक आहे :digits अंक.',
    'digits_between'       => 'या दरम्यान असणे आवश्यक आहे :min आणि :max अंक.',
    'dimensions'           => 'ही प्रतिमा अवैध परिमाणे आहेत.',
    'distinct'             => 'या क्षेत्रात हुबेहुब मूल्य आहे.',
    'email'                => 'हा ग्राह्य ई-मेल पत्ता असेल.',
    'ends_with'            => 'खालील एक समाप्त करणे आवश्यक आहे: :values.',
    'enum'                 => 'The selected value is invalid.',
    'exists'               => 'निवडलेली मूल्य अवैध आहे.',
    'file'                 => 'सामग्री फाइल असणे आवश्यक आहे.',
    'filled'               => 'ह्या फिल्डमध्ये व्हॅल्यू असायला हवी.',
    'gt'                   => [
        'array'   => 'सामग्रीमध्ये :value पेक्षा जास्त आयटम असणे आवश्यक आहे.',
        'file'    => 'फाइलचा आकार :value किलोबाइटपेक्षा जास्त असणे आवश्यक आहे.',
        'numeric' => 'मूल्य :value पेक्षा जास्त असणे आवश्यक आहे.',
        'string'  => 'स्ट्रिंग :value वर्णांपेक्षा मोठी असणे आवश्यक आहे.',
    ],
    'gte'                  => [
        'array'   => 'सामग्रीमध्ये :value आयटम किंवा अधिक असणे आवश्यक आहे.',
        'file'    => 'फाईलचा आकार :value किलोबाइट्सपेक्षा मोठा किंवा समान असणे आवश्यक आहे.',
        'numeric' => 'मूल्य :value पेक्षा मोठे किंवा समान असणे आवश्यक आहे.',
        'string'  => 'स्ट्रिंग :value वर्णांपेक्षा मोठी किंवा समान असणे आवश्यक आहे.',
    ],
    'image'                => 'प्रतिमा असणे आवश्यक आहे.',
    'in'                   => 'निवडलेली मूल्य अवैध आहे.',
    'in_array'             => 'हे मूल्य :other अस्तित्वात नाही.',
    'integer'              => 'हा पूर्णांक असणे आवश्यक आहे.',
    'ip'                   => 'हा एक वैध आंतरजाल पत्ता असणे आवश्यक आहे.',
    'ipv4'                 => 'हा एक वैध आयपीव्ही4 पत्ता असणे आवश्यक आहे.',
    'ipv6'                 => 'या वैध आंतरजाल6 पत्ता असणे आवश्यक आहे.',
    'json'                 => 'या असणे आवश्यक आहे एक वैध JSON स्ट्रिंग.',
    'lt'                   => [
        'array'   => 'सामग्रीमध्ये :value पेक्षा कमी आयटम असणे आवश्यक आहे.',
        'file'    => 'फाईलचा आकार :value किलोबाइट्सपेक्षा कमी असणे आवश्यक आहे.',
        'numeric' => 'मूल्य :value पेक्षा कमी असणे आवश्यक आहे.',
        'string'  => 'स्ट्रिंग :value वर्णांपेक्षा कमी असणे आवश्यक आहे.',
    ],
    'lte'                  => [
        'array'   => 'सामग्रीमध्ये :value पेक्षा जास्त आयटम नसावेत.',
        'file'    => 'फाइलचा आकार :value किलोबाइट्सपेक्षा कमी किंवा समान असणे आवश्यक आहे.',
        'numeric' => 'मूल्य :value पेक्षा कमी किंवा समान असणे आवश्यक आहे.',
        'string'  => 'स्ट्रिंग :value वर्णांपेक्षा कमी किंवा समान असणे आवश्यक आहे.',
    ],
    'mac_address'          => 'The value must be a valid MAC address.',
    'max'                  => [
        'array'   => 'सामग्रीमध्ये :max पेक्षा जास्त आयटम असू शकत नाहीत.',
        'file'    => 'फाईलचा आकार :max किलोबाइटपेक्षा जास्त असू शकत नाही.',
        'numeric' => 'मूल्य :max पेक्षा जास्त असू शकत नाही.',
        'string'  => 'स्ट्रिंग :max वर्णांपेक्षा जास्त असू शकत नाही.',
    ],
    'mimes'                => 'हा प्रकार एक फाइल असणे आवश्यक आहे: :values.',
    'mimetypes'            => 'हा प्रकार एक फाइल असणे आवश्यक आहे: :values.',
    'min'                  => [
        'array'   => 'मूल्यामध्ये किमान :min आयटम असणे आवश्यक आहे.',
        'file'    => 'फाईलचा आकार किमान :min किलोबाइट्स असणे आवश्यक आहे.',
        'numeric' => 'मूल्य किमान :min असणे आवश्यक आहे.',
        'string'  => 'स्ट्रिंग किमान :min वर्ण असणे आवश्यक आहे.',
    ],
    'multiple_of'          => 'मूल्य :value अनेक असणे आवश्यक आहे',
    'not_in'               => 'निवडलेली मूल्य अवैध आहे.',
    'not_regex'            => 'या स्वरूपात अवैध आहे.',
    'numeric'              => 'हा एक नंबर असणे आवश्यक आहे.',
    'password'             => 'गुप्तशब्द अयोग्य आहे.',
    'present'              => 'या क्षेत्रात उपस्थित असणे आवश्यक आहे.',
    'prohibited'           => 'हे फील्ड प्रतिबंधित आहे.',
    'prohibited_if'        => ':other :value आहे तेव्हा हे फील्ड प्रतिबंधित आहे.',
    'prohibited_unless'    => 'या क्षेत्रात प्रतिबंधित आहे तोपर्यंत :other आहे :values.',
    'prohibits'            => 'This field prohibits :other from being present.',
    'regex'                => 'या स्वरूपात अवैध आहे.',
    'required'             => 'या क्षेत्रात आवश्यक आहे.',
    'required_array_keys'  => 'This field must contain entries for: :values.',
    'required_if'          => 'या क्षेत्रात :other :value असताना आवश्यक आहे.',
    'required_unless'      => ':other मध्ये आहे तोपर्यंत हा क्षेत्रात आवश्यक आहे :values.',
    'required_with'        => 'या क्षेत्रात :values उपस्थित आहे, तेव्हा आवश्यक आहे.',
    'required_with_all'    => 'हे फील्ड :values उपस्थित असतात तेव्हा आवश्यक आहे.',
    'required_without'     => 'या क्षेत्रात :values उपस्थित नाही तेव्हा आवश्यक आहे.',
    'required_without_all' => 'या क्षेत्रात आवश्यक आहे, तेव्हा काहीही :values उपस्थित आहेत.',
    'same'                 => 'या क्षेत्रात मूल्य एक जुळणे आवश्यक आहे :other.',
    'size'                 => [
        'array'   => 'सामग्रीमध्ये :size आयटम असणे आवश्यक आहे.',
        'file'    => 'फाइलचा आकार :size किलोबाइट्स असणे आवश्यक आहे.',
        'numeric' => 'मूल्य :size असणे आवश्यक आहे.',
        'string'  => 'स्ट्रिंग :size वर्णांची असणे आवश्यक आहे.',
    ],
    'starts_with'          => 'या खालीलपैकी एक सुरू करणे आवश्यक आहे: :values.',
    'string'               => 'ही स्ट्रिंग असायला हवी.',
    'timezone'             => 'या वैध क्षेत्र असणे आवश्यक आहे.',
    'unique'               => 'हे आधीच घेतले गेले आहे.',
    'uploaded'             => 'या अपलोड करण्यासाठी अयशस्वी.',
    'url'                  => 'या स्वरूपात अवैध आहे.',
    'uuid'                 => 'एक वैध UUID नाव असणे आवश्यक आहे.',
    'custom'               => [
        'attribute-name' => [
            'rule-name' => 'सानुकूल-संदेश',
        ],
    ],
];
