<?php $__env->startSection('content'); ?>
    <div class="container-fluid py-4">
        <div class="row">
            <form action="/save-project" method="post">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="list-unstyled">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="col-lg-9 col-12 mx-auto">
                    <div class="card card-body mt-4">
                        <h6 class="mb-0"><?php echo e(__('New Project')); ?></h6>
                        <p class="text-sm mb-0"><?php echo e(__('Create new project')); ?></p>
                        <hr class="horizontal dark my-3">


                        <label for="projectName" class="form-label"><?php echo e(__('Project Name')); ?></label>
                        <input type="text"<?php if(!empty($project)): ?> value="<?php echo e($project->title); ?>"<?php endif; ?>   name="title" class="form-control" id="projectName">

                        <label class="mt-4 text-sm mb-0"><?php echo e(__('Project Summary')); ?></label>
                        <p class="form-text text-muted text-xs ms-1">
                            <?php echo e(__('Write a short summary of the project.Within 225 words')); ?>

                        </p>

                        <div class="form-group">

                            <textarea name="summary" class="form-control" rows="4" id="editor" name="budget"><?php if(!empty($project)): ?><?php echo e($project->summary); ?><?php endif; ?>
                            </textarea>
                        </div>

                        <div class="form-group">
                            <label for="example-text-input" class="form-control-label">
                                <?php echo e(__('Status')); ?>


                            </label><span class="text-danger">*</span>

                            <select class="form-select" aria-label="Default select example" name="status">

                                <option value="Pending"
                                        <?php if(($project->status ?? null) === 'Pending'): ?> selected <?php endif; ?>><?php echo e(__('Pending')); ?></option>
                                <option value="Started"
                                        <?php if(($project->status ?? null) === 'Started'): ?> selected <?php endif; ?>><?php echo e(__('Started')); ?></option>
                                <option value="Finished"
                                        <?php if(($project->status ?? null) === 'Finished'): ?> selected <?php endif; ?>><?php echo e(__('Finished')); ?></option>
                            </select>
                        </div>


                        <div class="row mt-4">
                            <div class="col-6">
                                <label class="form-label"><?php echo e(__('Start Date')); ?></label>
                                <input class="form-control" name="start_date" id="start_date" <?php if(!empty($project)): ?>value="<?php echo e($project->start_date); ?>"
                                       <?php else: ?>
                                       value="<?php echo e(date('Y-m-d')); ?>"
                                       <?php endif; ?> >
                            </div>
                            <div class="col-6">
                                <label class="form-label"><?php echo e(__('End Date')); ?></label>
                                <input class="form-control" name="end_date"  id="end_date"  <?php if(!empty($project)): ?>
                                value="<?php echo e($project->end_date); ?>"
                                       <?php else: ?>
                                       value="<?php echo e(date('Y-m-d')); ?>"
                                <?php endif; ?>>
                            </div>
                        </div>




                        <label class="mt-4 text-sm mb-0"><?php echo e(__('Project Description')); ?></label>
                        <p class="form-text text-muted text-xs ms-1">
                            <?php echo e(__('Write a well organised description of the project.')); ?>

                        </p>

                        <div class="form-group">
                            <textarea class="form-control" rows="10" id="description" name="description"><?php if(!empty($project)): ?><?php echo e($project->description); ?><?php endif; ?>
                            </textarea>
                        </div>
                    <?php echo csrf_field(); ?>
                        <?php if($project): ?>
                            <input type="hidden" name="id" value="<?php echo e($project->id); ?>">
                        <?php endif; ?>

                        <div class="d-flex  mt-4">

                            <button type="submit" name="button" class="btn bg-gradient-primary m-0 ">
                                <?php echo e(__('Save')); ?>

                            </button>
                        </div>
                    </div>
                </div>

            </form>

        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script>
        "use strict";
        $(function () {


            flatpickr("#start_date", {

                dateFormat: "Y-m-d",
            });

            flatpickr("#end_date", {

                dateFormat: "Y-m-d",
            });


            tinymce.init({
                selector: '#description',


                plugins: 'table,code',


            });

        });


    </script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/projects/create-project.blade.php ENDPATH**/ ?>