<?php $__env->startSection('content'); ?>

    <div class="page-header mb-4 border-radius-xl">
        <span class="mask bg-warning-light"></span>
        <div class="container">
            <div class="row">
                <div class="col-lg-12 my-auto">

                    <h4 class="text-warning fadeIn2 fadeInBottom mt-4">
                        <?php echo e(__('“An hour of planning can save you 10 hours of doing.”')); ?>


                    </h4>
                    <p class="text-warning opacity-8 fadeIn3 fadeInBottom">
                        <?php echo e(__('— Dale Carnegie')); ?>


                    </p>
                </div>
            </div>
            <a  href="/weekly-plan" type="button" class="btn btn-warning">
                <?php echo e(__('Make a Weekly Plan')); ?>


            </a>

        </div>
    </div>

    <div class="row">
        <div class="col-md-12 mt-4">
            <div class="card">
                <div class="card-header pb-0 px-3">
                    <h6 class="mb-0"><?php echo e(__('List of Weekly Plans')); ?></h6>
                </div>
                <div class="card-body pt-4 p-3">
                    <ul class="list-group">

                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="list-group-item border-0 d-flex p-4 mb-2 mt-3 bg-yellow-light border-radius-lg">
                                <div class="d-flex flex-column">
                                    <h6 class="mb-3 text-sm"><?php echo e($plan->title); ?></h6>

                                    <span class="text-xs mb-4">
                                        <?php echo e(__('From Date:')); ?>


                                        <span class="text-dark ms-sm-2 font-weight-bold ">
                                            <?php echo e($plan->from_date->format(config('app.date_format'))); ?>

                                        </span>

                                    </span>
                                    <span class="text-xs">
                                        <?php echo e(__('To Date:')); ?>


                                        <span class="text-dark ms-sm-2 font-weight-bold">
                                            <?php echo e($plan->to_date->format(config('app.date_format'))); ?>

                                        </span>

                                    </span>

                                </div>
                                <div class="ms-auto text-end">
                                    <a class="btn btn-link text-dark px-3 mb-0" href="/view-weekly-plans?id=<?php echo e($plan->id); ?>"><i class="fas fa-file-alt text-dark me-2" aria-hidden="true"></i><?php echo e(__('View')); ?></a>

                                    <a class="btn btn-link text-danger text-gradient px-3 mb-0" href="/delete/weekly-plan/<?php echo e($plan->id); ?>"><i class="far fa-trash-alt me-2"></i>Delete</a>
                                    <a class="btn btn-link text-dark px-3 mb-0" href="/weekly-plan?id=<?php echo e($plan->id); ?>"><i class="fas fa-pencil-alt text-dark me-2" aria-hidden="true"></i>Edit</a>
                                </div>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




                    </ul>
                </div>
            </div>
        </div>

    </div>




<?php $__env->stopSection(); ?>









<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/plans/weekly-planner.blade.php ENDPATH**/ ?>