<?php $__env->startSection('content'); ?>

    <div class="page-header mb-4 border-radius-xl">
        <span class="mask bg-gradient-dark"></span>
        <div class="container">
            <div class="row">
                <div class="col-lg-6 my-auto">

                    <h5 class="text-white fadeIn2 fadeInBottom mt-4 mb-4">
                        <?php echo e(__('Create Plans')); ?>

                    </h5>

                </div>
            </div>
            <a  href="/subscription-plan" type="button" class="btn bg-gradient-light"><?php echo e(__('Create Plan')); ?></a>


        </div>
    </div>


    <section class="">
        <div class="container">
            <div class="row">
                <div class="col-md-6 mx-auto text-center  mb-5">
                    <h3><?php echo e(__('Subscription Plan List')); ?></h3>
                    <p class="lead"><?php echo e(__('You can edit or delete the plans')); ?></p>
                </div>
            </div>
            <div class="row">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card mb-4">

                        <div class="row">

                            <div class="col-lg-8">
                                <div class="card-body">
                                    <h3 class="text-gradient text-info"><?php echo e($plan->name); ?></h3>
                                    <p><?php echo $plan->description; ?></p>
                                    <div class="row mt-5 mb-2">
                                        <div class="col-lg-3 col-12">
                                            <h6 class="text-dark tet-uppercase"><?php echo e(__('What is included')); ?></h6>
                                        </div>
                                        <div class="col-6">
                                            <hr class="horizontal dark">
                                        </div>
                                    </div>
                                    <div class="row">

                                        <?php if($plan->features): ?>

                                            <?php $__currentLoopData = json_decode($plan->features); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <div class="col-lg-6 col-md-6 col-12 ps-0">
                                                    <div class="d-flex align-items-center p-2">
                                                        <div class="icon icon-shape icon-xs rounded-circle bg-gradient-dark opacity-6 shadow text-center">
                                                            <i class="fas fa-check opacity-10"></i>
                                                        </div>
                                                        <div>
                                                            <span class="ps-2"><?php echo e($feature); ?></span>
                                                        </div>
                                                    </div>

                                                </div>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                        <?php endif; ?>


                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 my-auto">
                                <div class="card-body text-center">
                                    <h6 class="mt-sm-4 mt-0 mb-0"><?php echo e(__('Monthly Price')); ?></h6>
                                    <h2 class="mt-0">
                                        <small>$</small><?php echo e($plan->price_monthly); ?>

                                    </h2>
                                    <h6 class="mt-sm-4 mt-0 mb-0">Yearly Price</h6>
                                    <h2 class="mt-0">
                                        <small>$</small><?php echo e($plan->price_yearly); ?>

                                    </h2>



                                </div>

                            </div>

                            <div>

                                <a href="/subscription-plan?id=<?php echo e($plan->id); ?>" type="button" class="btn bg-gradient-dark mt-3"><?php echo e(__('Edit')); ?></a>
                                <a href="/delete/subscription-plan/<?php echo e($plan->id); ?>" type="button" class="btn bg-gradient-primary mt-3"><?php echo e(__('Delete')); ?></a>

                            </div>



                        </div>


                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/super-admin/plans.blade.php ENDPATH**/ ?>