<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="font-weight-bolder"><?php echo e(__('SWOT Analysis')); ?></h4>
                    <hr>
                    <form method="post" action="/save-swot">
                        <?php if($errors->any()): ?>
                            <div class="alert bg-pink-light text-danger">
                                <ul class="list-unstyled">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <div class="form-group">
                            <label for="exampleFormControlTextarea1">
                                <?php echo e(__('Business/Company Name')); ?>

                            </label><label class="text-danger">*</label>
                            <input class="form-control" name="company_name" id="company_name"

                                   <?php if(!empty($model)): ?>
                                   value="<?php echo e($model->company_name); ?>"
                                <?php endif; ?>
                            >

                        </div>
                        <div class="row mt-4">
                            <div class="col align-self-end">
                                <div class="col align-self-center">
                                    <div class="form-group">
                                        <label for="exampleFormControlTextarea1">
                                            <?php echo e(__('Strengths')); ?>

                                        </label>
                                        <p class="form-text text-muted text-xs ms-1">
                                            <?php echo e(__('What are the strengths?')); ?>


                                        </p>
                                        <textarea class="form-control mt-4" rows="10" id="strengths"
                                                  name="strengths"><?php if(!empty($model)): ?><?php echo e($model->strengths); ?><?php endif; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col align-self-center">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">
                                        <?php echo e(__('Weaknesses')); ?>

                                    </label>
                                    <p class="form-text text-muted text-xs ms-1">
                                        <?php echo e(__('What are the weaknesses?')); ?>


                                    </p>
                                    <textarea class="form-control mt-4" rows="10" id="weaknesses"
                                              name="weaknesses"><?php if(!empty($model)): ?><?php echo e($model->weaknesses); ?><?php endif; ?></textarea>
                                </div>
                            </div>
                        </div>
                            <div class="row mt-4">
                                <div class="col align-self-end">
                                    <div class="col align-self-center">
                                        <div class="form-group">
                                        <label for="exampleFormControlTextarea1">
                                            <?php echo e(__('Opportunities')); ?>

                                        </label>
                                        <p class="form-text text-muted text-xs ms-1">
                                            <?php echo e(__('What are the opportunities?')); ?>

                                        </p>
                                        <textarea class="form-control mt-4" rows="10" id="opportunities"
                                                  name="opportunities"><?php if(!empty($model)): ?><?php echo e($model->opportunities); ?><?php endif; ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col align-self-center">
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">
                                        <?php echo e(__('Threats')); ?>

                                    </label>
                                    <p class="form-text text-muted text-xs ms-1">
                                        <?php echo e(__('What are the Threats?')); ?>

                                    </p>
                                    <textarea class="form-control mt-4" rows="10" id="threats"
                                              name="threats"><?php if(!empty($model)): ?><?php echo e($model->threats); ?><?php endif; ?></textarea>
                                </div>
                            </div>
                        </div>
                        <?php if($model): ?>
                            <input type="hidden" name="id" value="<?php echo e($model->id); ?>">
                        <?php endif; ?>
                        <?php echo csrf_field(); ?>
                        <button class="btn btn-info mt-4" type="submit"><?php echo e(__('Save')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>

        (function(){
            "use strict";
            tinymce.init({
                selector: '#strengths',

                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#weaknesses',

                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#threats',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
            tinymce.init({
                selector: '#opportunities',
                plugins: 'lists,table',
                toolbar: 'numlist bullist',
                lists_indent_on_tab: false,
                branding: false,
            });
        })();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/swot/write-swot.blade.php ENDPATH**/ ?>