<?php $__env->startSection('title',__('Write Blog')); ?>
<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col">
            <h5 class="text-white fw-bolder">
                <?php echo e(__('Blog')); ?>

            </h5>
        </div>
        <div class="col text-end">
            <a href="/blogs" type="button" class="btn btn-info text-white"><?php echo e(__('Articles')); ?></a>
        </div>
    </div>
    <div class="">
        <form enctype="multipart/form-data" action="/save-blog" method="post">
            <?php if($errors->any()): ?>
                <div class="alert bg-pink-light text-danger">
                    <ul class="list-unstyled">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <div class="card col-lg-9 col-12 mx-auto">
                <div class="card-header border-bottom">
                    <h5 class="card-title"><?php echo e(__('Write Blog Post')); ?></h5>

                </div>

                <div class="card-body">

                    <div class="">

                        <div class="mb-3">
                            <label for="blogTitle" class="form-label"><?php echo e(__('Title')); ?></label><label class="text-danger">*</label>
                            <input type="text" name="title"  value="<?php echo e($blog->title ?? old('title') ?? ''); ?>" class="form-control" id="blogTitle">
                        </div>
                        <label for="basic-url" for="blogSlug" class="form-label"><?php echo e(__('Slug')); ?></label>
                        <div class="input-group mb-3">
                            <span class="input-group-text fw-bolder"><?php echo e(config('app.url')); ?>/blog/</span>
                            <input type="text" value="<?php echo e($blog->slug ?? old('slug') ?? ''); ?>" id="blogSlug" name="slug" class="form-control ps-1">
                        </div>
                        <div class="mb-2">
                            <label for="exampleFormControlInput1" class="form-label"> <?php echo e(__('Topic/Subject')); ?></label><label class="text-danger">*</label>
                            <input type="text" name="topic" value="<?php echo e($blog->topic ?? old('topic') ?? ''); ?>"class="form-control" id="topic">
                        </div>
                        <div class="align-self-center mb-3">
                            <div>
                                <label for="cover_photo" class="form-label mt-4"><?php echo e(__('Upload Cover Photo')); ?></label>
                                <input class="form-control" name="cover_photo" type="file" id="cover_photo_file">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="exampleFormControlTextarea1" class="form-label"><?php echo e(__('Write Notes')); ?></label>
                            <textarea class="form-control" name="notes" id="notes"
                                      rows="5"><?php if(!empty($blog)): ?><?php echo $blog->notes; ?><?php endif; ?></textarea>
                        </div>
                        <?php echo csrf_field(); ?>
                        <?php if($blog): ?>
                            <input type="hidden" name="id" value="<?php echo e($blog->id); ?>">
                        <?php endif; ?>
                        <button class="btn btn-info" type="submit"><?php echo e(__('Save')); ?></button>
                    </div>
                </div>

            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        (function () {
            "use strict";
            tinymce.init({
                selector: '#notes',
                plugins: [
                    'insertdatetime media table paste code help wordcount'
                ],
                min_height: 500,
                max_height: 800,
                convert_newlines_to_brs: false,
                statusbar: false,
                relative_urls: false,
                remove_script_host: false,
                language: 'en',
            });

            <?php if(empty($blog)): ?>

            let blogTitle = document.getElementById('blogTitle');

            blogTitle.addEventListener('keyup', function (event) {
                event.preventDefault();
                let title = blogTitle.value;
                document.getElementById('blogSlug').value = title.toLowerCase().split(' ').join('-');
            });

            <?php endif; ?>
        })();
    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/blog/write-blog.blade.php ENDPATH**/ ?>