<?php $__env->startSection('head'); ?>
    <link href="<?php echo e(PUBLIC_DIR); ?>/lib/canvas/css/canvas.css?v=9" rel="stylesheet"/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <form method="post" action="/save-canvas" id="save_cavas">
        <?php if($errors->any()): ?>
            <div class="alert bg-pink-light text-danger">
                <ul class="list-unstyled">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error => $error_message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error_message); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

    <div class="row">
        <div class="col">
            <h5 class=" text-secondary fw-bolder">
                <?php echo e(__('Brainstorming & Ideation')); ?>

            </h5>
        </div>

        <?php echo csrf_field(); ?>
        <input type="hidden" name="id" id="input_id" value="<?php echo e($canvas->id ?? 0); ?>">
        <div class="col text-end">
            <button type="submit" class="btn btn-info">
                <?php echo e(__('Save')); ?>

            </button>
        </div>
    </div>




       <div class="mb-3 ">
           <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('Title')); ?></label><label class="text-danger">*</label>
           <input type="text" name="title"  value="<?php echo e($canvas->title ?? old('title') ?? ''); ?>" class="form-control" id="title">
       </div>

       <div class="my-drawing " style="height: 800px;"></div>
   </form>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(PUBLIC_DIR); ?>/lib/canvas/js/canvas.min.js?v=50"></script>
    <script>
        $(function () {
            const lc = LC.init(document.getElementsByClassName('my-drawing')[0],{
                imageURLPrefix: '<?php echo e(PUBLIC_DIR); ?>/lib/canvas/img',
                imageSize: {
                    width: 1100, height: null,
                },
                backgroundColor:'#F2F2F2',
                tools: [LC.tools.Pencil, LC.tools.Eraser, LC.tools.Line,
                    LC.tools.Rectangle, LC.tools.Text,LC.tools.Pan, LC.tools.Ellipse,LC.tools.Eyedropper],
                strokeWidths:[1, 2, 5, 10, 20,],

                <?php if(!empty($canvas->src)): ?>
                    snapshot: <?php echo $canvas->src; ?>,
                <?php endif; ?>

            });

            let $save_canvas = $('#save_cavas');
            $save_canvas.on('submit',function (event) {
                event.preventDefault();
                $.post( "/save-canvas", {
                    title: $('#title').val(),
                    id: $('#input_id').val(),
                    src: JSON.stringify(lc.getSnapshot()),
                    image: lc.getImage().toDataURL(),
                    _token: '<?php echo e(csrf_token()); ?>',
                })
                    .done(function( data ) {
                        window.location = data.url;
                    });
            });


        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/plans/brainstorm.blade.php ENDPATH**/ ?>