<?php $__env->startSection('content'); ?>


    <h5 class="mb-3"><?php echo e(__('Vision Board')); ?></h5>

    <form action="/vision-board" class="form-control dropzone" id="dropzone">
        <div class="fallback">
            <input name="file" type="file" multiple />
        </div>
    </form>



    <!-- Gallery -->


    <div class="row mt-4" data-masonry='{"percentPosition": true }'>
        <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-4 mb-4">

            <div class="card">
                <div class="card-body">
                    <img
                        src="<?php echo e(asset(PUBLIC_DIR.'/storage/'.$image->path)); ?>"
                        class="w-100 shadow-1-strong rounded mb-3"
                        alt=""
                    />
                    <a  href="/delete/image/<?php echo e($image->id); ?>" class="btn btn-outline-dark rounded-circle p-2 mb-0" type="button">
                        <i class="fas fa-trash p-2"></i>
                    </a>
                </div>
            </div>





        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



    </div>



<?php $__env->stopSection(); ?>




<?php $__env->startSection('script'); ?>
    <script>
        "use strict"

        Dropzone.autoDiscover = false;
        Dropzone.options.dropzone = {
            acceptedFiles:'image/*'
        };

        $(function () {
            $("#dropzone").dropzone({
                url: "/vision-board",
                success: function (file, response) {
                    location.reload();
                },
                error: function (file, response) {
                    file.previewElement.classList.add("dz-error");
                },
                sending: function(file, xhr, formData){
                    formData.append('_token', '<?php echo e(csrf_token()); ?>');
                }
            });
        })
    </script>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/goals/vision-board.blade.php ENDPATH**/ ?>