<?php $__env->startSection('content'); ?>
     <div class=" row mb-2">
        <div class="col">
            <h5 class=" text-secondary fw-bolder">
                <?php echo e(__('Users')); ?>

            </h5>
        </div>
        <div class="col text-end">
            <a class="btn btn-info " href="/add-user"><i class="fas fa-plus"></i>&nbsp;&nbsp;
                <?php echo e(__(' Add New User')); ?>

            </a>
        </div>
    </div>
<div class="">
        <div class="row">
            <div class="col-12">
                <div class="card card-body mb-4">
                    <div class="card-body px-0 pt-0 pb-2">
                        <div class="table-responsive p-0">
                            <table class="  table align-items-center mb-0" id="cloudonex_table">
                                <thead >
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('User')); ?></th>

                                    <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Workspace Name')); ?></th>
                                    <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Account Created')); ?></th>
                                    <th class="text-secondary opacity-7"></th>
                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workspace_user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                <div>
                                                    <?php if(empty($workspace_user['photo'])): ?>
                                                        <div
                                                            class="avatar avatar-md rounded-circle bg-purple-light  border-radius-md p-2 ">
                                                            <h6 class="text-uppercase text-purple "><?php echo e($workspace_user->first_name['0']); ?><?php echo e($workspace_user->last_name['0']); ?></h6>
                                                        </div>
                                                    <?php else: ?>

                                                        <img src="<?php echo e(PUBLIC_DIR); ?>/uploads/<?php echo e($workspace_user->photo); ?>"
                                                             alt="" class="avatar avatar-md shadow-sm">
                                                    <?php endif; ?>
                                                </div>
                                                <div class="d-flex flex-column justify-content-center px-3">
                                                    <h6 class="mb-0 text-sm"><?php echo e($workspace_user->first_name); ?> <?php echo e($workspace_user->last_name); ?></h6>
                                                    <p class="text-xs text-secondary mb-0"><?php echo e($workspace_user->email); ?></p>
                                                </div>
                                            </div>
                                        </td>

                                        <td class="align-middle text-center text-sm fw-bolder">
                                            <?php if(!empty($workspaces[$workspace_user->workspace_id])): ?>
                                                <?php echo e($workspaces[$workspace_user->workspace_id]->name); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td class="align-middle text-center">
                                            <span
                                                class="text-secondary text-xs font-weight-bold"> <?php echo e((\App\Supports\DateSupport::parse($workspace_user->created_at))->format(config('app.date_time_format'))); ?> </span>
                                        </td>
                                        <td class="align-middle">
                                            <div class="ms-auto text-end">
                                                <a class="btn btn-link text-dark px-3 mb-0" href="/user-edit/<?php echo e($workspace_user->id); ?>"><i class="fas fa-pencil-alt text-dark me-2" aria-hidden="true"></i><?php echo e(__('Edit')); ?></a>

                                                <a class="btn btn-link text-dark px-3 mb-0"
                                                   href="/user-profile?id=<?php echo e($workspace_user->id); ?>"><i
                                                        class="fas fa-file-alt text-dark me-2"
                                                        aria-hidden="true"></i><?php echo e(__('View')); ?></a>

                                                <?php if($user->id != $workspace_user->id): ?>

                                                    <a class="btn btn-link text-danger text-gradient px-3 mb-0"
                                                       href="/delete-user/<?php echo e($workspace_user->id); ?>"><i
                                                            class="far fa-trash-alt me-2"></i><?php echo e(__('Delete')); ?></a>

                                                <?php endif; ?>

                                            </div>

                                        </td>
                                    </tr>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        "use strict";
        $(document).ready(function () {
            $('#cloudonex_table').DataTable(
            );

        });
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/super-admin/users.blade.php ENDPATH**/ ?>