<?php $__env->startSection('content'); ?>

    <div class="page-header mb-4 border-radius-xl" style="background-image: url('https://images.unsplash.com/photo-1552793494-111afe03d0ca?ixlib=rb-1.2.1&amp;ixid=eyJhcHBfaWQiOjEyMDd9&amp;auto=format&amp;fit=crop&amp;w=1920&amp;q=80');">
        <span class="mask bg-gradient-dark"></span>
        <div class="container">
            <div class="row">
                <p class="col-lg-6 my-auto">

                <h5 class="text-white fadeIn2 fadeInBottom mt-4">Take Actions
                </h5>
                <p class="lead text-white opacity-8 fadeIn3 fadeInBottom"> “Action is the foundational key to all success.”

                </p>
                <p class="lead text-white opacity-8 fadeIn3 fadeInBottom"> – Pablo Picasso</p>
            </div>
            <a  href="/add-task" type="button" class="btn bg-gradient-light mt-4">Add todays to-dos</a>
            <a  href="/add-task?for=project" type="button" class="btn bg-gradient-light mt-4">Add Projects' to-dos</a>
            <a  href="/add-task?for=goal" type="button" class="btn bg-gradient-light mt-4">Add Goals' to-dos</a>


        </div>

    </div>



    <div class="row">
        <div class="col-md-8 mt-4">
            <div class="card">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-md-6">
                            <h6 class="mb-0">Todays to-do list</h6>
                        </div>
                        <ul class="list-group list-group-flush" data-toggle="checklist">
                            <?php $__currentLoopData = $todos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $todo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                <li class="list-group-item border-0 flex-column align-items-start ps-0 py-0 mb-3">
                                    <div class="checklist-item checklist-item-primary ps-2 ms-3">
                                        <div class="d-flex align-items-center">
                                            <div class="form-check">
                                                <input class="form-check-input todo_checkbox" type="checkbox"
                                                       data-id="<?php echo e($todo->id); ?>"

                                                       <?php if($todo->completed): ?> checked <?php endif; ?>

                                                >
                                            </div>
                                            <h6 class="mb-0 text-dark font-weight-bold text-sm"><?php echo e($todo->title); ?></h6>
                                            <div class="dropdown float-lg-end ms-auto pe-4">
                                                <a href="javascript:;" class="cursor-pointer" id="dropdownTable2" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <a class="btn btn-link text-danger text-gradient px-3 mb-0" href="/delete/today-todo/<?php echo e($todo->id); ?>"><i class="far fa-trash-alt me-2"></i>Delete</a>
                                                    <a class="btn btn-link text-dark px-3 mb-0" href="/add-task/?id=<?php echo e($todo->id); ?>"><i class="fas fa-pencil-alt text-dark me-2" aria-hidden="true"></i>Edit</a>
                                                </a>

                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center ms-4 mt-3 ps-1">
                                            <div>
                                                <p class="text-xs mb-0 text-secondary font-weight-bold">Date</p>
                                                <span class="text-xs font-weight-bolder"><?php echo e($todo->date); ?></span>
                                            </div>

                                        </div>
                                    </div>
                                    <hr class="horizontal dark mt-4 mb-0">
                                </li>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                        </ul>

                    </div>
                    <hr class="horizontal dark mb-0">
                </div>

            </div>
        </div>
        <div class="col-lg-4 col-12 mt-4 mt-lg-0">
            <div class="card overflow-hidden">
                <div class="card-header p-3 pb-0">
                    <div class="d-flex align-items-center">
                        <div class="icon icon-shape bg-gradient-info shadow text-center border-radius-md">
                            <i class="ni ni-calendar-grid-58 text-lg opacity-10" aria-hidden="true"></i>
                        </div>
                        <div class="ms-3">
                            <p class="text-sm mb-0 text-capitalize font-weight-bold"> Todays Todos</p>
                            <h5 class="font-weight-bolder mb-0">
                               <?php echo e($todays_todos); ?>

                            </h5>
                        </div>
                        <div class="progress-wrapper ms-auto w-25">
                            <div class="progress-info">
                                <div class="progress-percentage">
                                    <span class="text-xs font-weight-bold">60%</span>
                                </div>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-gradient-info w-60" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body mt-3 p-0">

                </div>
            </div>
            <div class="card overflow-hidden mt-4">
                <div class="card-header p-3 pb-0">
                    <div class="d-flex align-items-center">
                        <div class="icon icon-shape bg-gradient-info shadow text-center border-radius-md">
                            <i class="ni ni-calendar-grid-58 text-lg opacity-10" aria-hidden="true"></i>
                        </div>
                        <div class="ms-3">
                            <p class="text-sm mb-0 text-capitalize font-weight-bold"> Projects' Todos</p>
                            <h5 class="font-weight-bolder mb-0">
                               <?php echo e($project_todos); ?>

                            </h5>
                        </div>
                        <div class="progress-wrapper ms-auto w-25">
                            <div class="progress-info">
                                <div class="progress-percentage">
                                    <span class="text-xs font-weight-bold">60%</span>
                                </div>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-gradient-info w-60" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body mt-3 p-0">

                </div>
            </div>
            <div class="card overflow-hidden mt-4">
                <div class="card-header p-3 pb-0">
                    <div class="d-flex align-items-center">
                        <div class="icon icon-shape bg-gradient-info shadow text-center border-radius-md">
                            <i class="ni ni-calendar-grid-58 text-lg opacity-10" aria-hidden="true"></i>
                        </div>
                        <div class="ms-3">
                            <p class="text-sm mb-0 text-capitalize font-weight-bold"> Goal Todos</p>
                            <h5 class="font-weight-bolder mb-0">
                                <?php echo e($goal_todos); ?>

                            </h5>
                        </div>
                        <div class="progress-wrapper ms-auto w-25">
                            <div class="progress-info">
                                <div class="progress-percentage">
                                    <span class="text-xs font-weight-bold">60%</span>
                                </div>
                            </div>
                            <div class="progress">
                                <div class="progress-bar bg-gradient-info w-60" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body mt-3 p-0">

                </div>
            </div>

        </div>

    </div>






<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>


<script>
    $(function () {
        $('.todo_checkbox').on('change',function () {
            let that = $(this);
            if(this.checked)
            {
                $.post('/todos/change-status',{
                    id: that.attr('data-id'),
                    status: 'Completed',
                    _token: '<?php echo e(csrf_token()); ?>',
                });
            }
            else{
                $.post('/todos/change-status',{
                    id: that.attr('data-id'),
                    status: 'Not Completed',
                    _token: '<?php echo e(csrf_token()); ?>',
                });
            }
        });
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.marketing_crm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/marketing-crm/resources/views/actions/todos.blade.php ENDPATH**/ ?>