<?php $__env->startSection('content'); ?>
    <div class="">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="card-header pb-0">
                        <h6><?php echo e(__('Workspaces')); ?></h6>
                    </div>
                    <div class="card-body px-0 pt-0 pb-2">
                        <div class="table-responsive p-0">
                            <table class="table align-items-center mb-0">
                                <thead>
                                <tr>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Workspace Name')); ?></th>
                                    <th class="text-uppercase text-secondary text-xxs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Created_at')); ?></th>
                                    <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('Status')); ?></th>

                                    <th class="text-secondary opacity-7"></th>
                                </tr>
                                </thead>
                                <tbody>

                                <?php $__currentLoopData = $workspaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workspace): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex px-2 py-1">

                                                <div class="d-flex flex-column justify-content-center">
                                                    <h6 class="mb-0 text-sm"><?php echo e($workspace->name); ?> </h6>
                                                    <p class="text-xs text-secondary mb-0"></p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <p class="text-xs font-weight-bold mb-0"><?php echo e($workspace->created_at); ?></p>

                                        </td>
                                        <td class="align-middle text-center text-sm">
                                            <?php if($workspace->subscribed): ?>
                                                <span class="badge badge-sm bg-gradient-success"><?php echo e(__('Subscribed')); ?></span>
                                            <?php else: ?>
                                                <span class="badge badge-sm bg-gradient-danger"><?php echo e(__('Not Subscribed')); ?></span>
                                            <?php endif; ?>
                                        </td>

                                        <td class="align-middle">

                                            <?php if($workspace->id !== $user->workspace_id): ?>

                                                <a class="btn btn-link text-danger text-gradient px-3 mb-0" href="/delete-workspace/<?php echo e($workspace->id); ?>"><i class="far fa-trash-alt me-2"></i><?php echo e(__('Delete')); ?></a>

                                            <?php endif; ?>

                                        </td>
                                    </tr>


                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.super-admin-portal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/super-admin/workspaces.blade.php ENDPATH**/ ?>