<?php $__env->startSection('content'); ?>


    <div class="container-fluid py-4">
        <div class="card">
            <div class="card-header">
                Add Things to Learn
            </div>

            <div class="card-body">
                <form action="/save-to-learn" method="post">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="list-unstyled">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <div class="form-group">
                        <label for="example-text-input" class="form-control-label">What topic do you want to learn</label><span class="text-danger">*</span>
                        <input class="form-control" type="text" name="title" <?php if(!empty($to_learn)): ?> value="<?php echo e($to_learn->title); ?>" <?php endif; ?> id="example-text-input">
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="example-date-input" class="form-control-label">Start Date</label>
                                <input class="form-control" name="start_date"  id="start_date" type="date"
                                       <?php if(!empty($to_learn)): ?>
                                value="<?php echo e($to_learn->start_date); ?>"
                                       <?php else: ?>
                                       value="{date('Y-m-d')}"
                                <?php endif; ?>>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="example-date-input" class="form-control-label">End Date</label>
                                <input class="form-control" name="end_date" type="date"  id="end_date" <?php if(!empty($to_learn)): ?>
                                value="<?php echo e($to_learn->end_date); ?>"
                                       <?php else: ?>
                                       value="{date('Y-m-d')}"
                                <?php endif; ?>>
                            </div>

                        </div>
                    </div>
                    <div class="form-group">
                        <label for="exampleFormControlTextarea1">Description</label>
                        <textarea class="form-control" name="description" id="description" rows="10"><?php if(!empty($to_learn)): ?><?php echo e($to_learn->description); ?><?php endif; ?></textarea>
                    </div>

                     <?php echo csrf_field(); ?>
                    <?php if($to_learn): ?>
                        <input type="hidden" name="id" value="<?php echo e($to_learn->id); ?>">
                    <?php endif; ?>
                    <button type="submit" class="btn bg-gradient-secondary">Save</button>
                    <button type="button" class="btn bg-gradient-primary">Close</button>
                </form>

            </div>

        </div>

    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

    <script>
        $(function () {


            flatpickr("#start_date", {

                dateFormat: "Y-m-d",
            });

            flatpickr("#end_date", {

                dateFormat: "Y-m-d",
            });


            tinymce.init({
                selector: '#description',


                plugins: 'table,code,advlist',


            });
        });


    </script>

<?php $__env->stopSection(); ?>







<?php echo $__env->make('layouts.marketing_crm', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/marketing-crm/resources/views/actions/add-tolearn.blade.php ENDPATH**/ ?>