<?php $__env->startSection('content'); ?>

    <div class="row mb-5">
        <div class=" col-lg-8 col-12 mx-auto mt-lg-0 mt-4">
            <h5 class=" text-secondary fw-bolder">
                <?php echo e(__('General Settings')); ?>

            </h5>
            <div class="card">
                <div class="card-body">
                    <form enctype="multipart/form-data" action="/settings" method="post">

                        <?php if($errors->any()): ?>
                            <div class="alert bg-pink-light text-danger">
                                <ul class="list-unstyled">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <div class="mt-4"  id="basic-info">
                            <div class=" pt-0">
                                <div class="row">
                                    <label class="form-label"><?php echo e(__('Workspace Name')); ?></label>
                                    <div class="input-group">
                                        <input id="firstName" name="workspace_name" value="<?php echo e($workspace->name); ?>" class="form-control" type="text" required="required">
                                    </div>
                                </div>

                                <?php if($user->super_admin): ?>
                                    <div class="row">
                                        <div class="col-md-12 align-self-center">
                                            <div>
                                                <label for="logo_file" class="form-label mt-4"><?php echo e(__('Upload Logo')); ?></label>
                                                <input class="form-control" name="logo" type="file" id="logo_file">
                                            </div>
                                        </div>
                                    </div>

                                <?php endif; ?>
                                <?php if($user->super_admin): ?>
                                    <div class="row">
                                        <div class="col-md-12 align-self-center">
                                            <div>
                                                <label for="logo_file" class="form-label mt-4"><?php echo e(__('Upload favicon')); ?></label>
                                                <input class="form-control" name="favicon" type="file" id="favicon_file">
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if($user->super_admin): ?>
                                    <label class="form-label mt-3"><?php echo e(__('Currency')); ?></label>

                                    <div class="input-group">
                                        <input id="currency" name="currency" value="<?php echo e($settings['currency'] ?? config('app.currency')); ?>"
                                               class="form-control" type="text" required="required">
                                    </div>

                                <?php endif; ?>


                                <?php if($user->super_admin): ?>
                                    <div class="row">
                                        <div class="col-md-12 align-self-center">
                                            <div>
                                                <label class="form-label mt-4"><?php echo e(__('Landing Page Language')); ?></label>
                                                <select class="form-select" name="language" id="choices-language"><?php $__currentLoopData = $available_languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($key); ?>" <?php if(($settings['language'] ?? null)===$key): ?> selected <?php endif; ?> ><?php echo e($value); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                <?php endif; ?>

                                <?php if($user->super_admin): ?>
                                    <div class="row">
                                        <div class="col-md-12 align-self-center">
                                            <div>
                                                <label for="free_trial_days" class="form-label mt-4"><?php echo e(__('Free Trial Days')); ?></label>
                                                <input class="form-control" name="free_trial_days" type="number" id="free_trial_days" value="<?php echo e($settings['free_trial_days'] ?? ''); ?>">
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if($user->super_admin): ?>

                                    <div class="row">
                                        <div class="col-md-12 align-self-center">
                                            <div>
                                                <label for="free_trial_days" class="form-label mt-4"><?php echo e(__('Landing Page')); ?></label>
                                                <select class="form-select" aria-label="Default select example" name="landingpage">

                                                    <option value="Default"
                                                            <?php if(($settings['landingpage'] ?? null) === 'Default'): ?> selected <?php endif; ?>
                                                    ><?php echo e(__('Default landing page')); ?></option>
                                                    <option value="Login"
                                                            <?php if(($settings['landingpage'] ?? null) === 'Login'): ?> selected <?php endif; ?>><?php echo e(__('Login Page')); ?></option>
                                                </select>

                                            </div>
                                        </div>
                                    </div>
                                    <label  class="form-label mt-4"><?php echo e(__('Custom Script')); ?></label>
                                    <div class="input-group">
                                        <textarea id="custom_script" name="custom_script"  class="form-control" type="text"><?php echo e($settings['custom_script'] ?? ''); ?></textarea>
                                    </div>
                                    <label  class="form-label mt-4"><?php echo e(__('Meta Description')); ?></label>
                                    <div class="input-group">
                                        <textarea id="meta_description" name="meta_description"  class="form-control" type="text"><?php echo e($settings['meta_description'] ?? ''); ?></textarea>
                                    </div>

                                <?php endif; ?>


                                <?php echo csrf_field(); ?>
                                <button class="btn btn-info float-left mt-4 mb-0"><?php echo e(__('Update')); ?> </button>
                            </div>
                        </div>
                    </form>

                </div>

            </div>

        </div>
    </div>



    <?php if($user->super_admin): ?>



        <h5 class="col-lg-8 col-12 mx-auto mb-3 text-secondary fw-bolder">
            <?php echo e(__('OpenAI API Key')); ?>

        </h5>

        <div class="card col-lg-8 col-12 mx-auto shadow mb-6">

            <div class="card-body">

                <div class="accordion-1">
                    <div class="accordion" id="accordionSettings">

                        <div class="accordion-item mb-3">
                            <h5 class="accordion-header" id="headingTwo">
                                <button class="accordion-button border-bottom font-weight-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    <?php echo e(__('OpenAI API Key')); ?>

                                    <i class="collapse-close fa fa-plus text-xs pt-1 position-absolute end-0 me-3" aria-hidden="true"></i>
                                    <i class="collapse-open fa fa-minus text-xs pt-1 position-absolute end-0 me-3" aria-hidden="true"></i>
                                </button>
                            </h5>
                            <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo" data-bs-parent="#accordionRental">
                                <div class="accordion-body text-sm">

                                    <form action="/settings/save-openai-config" method="post">



                                        <div class="mt-3">
                                            <div class=" pt-0">
                                                <div class="row mb-4">
                                                    <label for="recaptcha_api_key" class="form-label"><?php echo e(__('OpenAI API Key')); ?></label>
                                                    <div class="input-group">
                                                        <input id="recaptcha_api_key" name="openai_api_key" value="<?php echo e($settings['openai_api_key'] ?? ''); ?>"
                                                               class="form-control" type="text" >
                                                    </div>
                                                </div>

                                                <?php echo csrf_field(); ?>


                                                    <button class="btn btn-info float-left mb-0 mt-3"><?php echo e(__('Save')); ?></button>


                                            </div>
                                        </div>


                                    </form>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>


            </div>
        </div>
    <?php endif; ?>
    <?php if($user->super_admin): ?>



        <h5 class="col-lg-8 col-12 mx-auto mb-3 text-secondary fw-bolder">
            <?php echo e(__('reCaptcha Settings')); ?>

        </h5>

        <div class="card col-lg-8 col-12 mx-auto shadow mb-6">

            <div class="card-body">

                <div class="accordion-1">
                    <div class="accordion" id="accordionSettings">

                        <div class="accordion-item mb-3">
                            <h5 class="accordion-header" id="headingTwo">
                                <button class="accordion-button border-bottom font-weight-bold" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    <?php echo e(__('reCAPTCHA v2')); ?>

                                    <i class="collapse-close fa fa-plus text-xs pt-1 position-absolute end-0 me-3" aria-hidden="true"></i>
                                    <i class="collapse-open fa fa-minus text-xs pt-1 position-absolute end-0 me-3" aria-hidden="true"></i>
                                </button>
                            </h5>
                            <div id="collapseTwo" class="accordion-collapse collapse show" aria-labelledby="headingTwo" data-bs-parent="#accordionRental">
                                <div class="accordion-body text-sm">

                                    <form action="/settings/save-recaptcha-config" method="post">



                                        <div class="mt-3">
                                            <div class=" pt-0">


                                                <div class="row mb-4">
                                                    <label for="recaptcha_api_key" class="form-label"><?php echo e(__('Site Key')); ?></label>
                                                    <div class="input-group">
                                                        <input id="recaptcha_api_key" name="recaptcha_api_key" value="<?php echo e($settings['recaptcha_api_key'] ?? ''); ?>"
                                                               class="form-control" type="text" required="required">
                                                    </div>
                                                </div>
                                                <div class="row mb-4">
                                                    <label for="recaptcha_api_secret" class="form-label"><?php echo e(__('Secret Key')); ?></label>

                                                    <div class="input-group">
                                                        <input id="recaptcha_api_secret" name="recaptcha_api_secret" value="<?php echo e($settings['recaptcha_api_secret'] ?? ''); ?>"
                                                               class="form-control" type="text" required="required">
                                                    </div>
                                                </div>
                                                <?php if($user->super_admin): ?>

                                                    <div class="form-check form-switch mt-3">
                                                        <input class="form-check-input" type="checkbox" role="switch" id="config_recaptcha_in_user_login" name="config_recaptcha_in_user_login" value="1"
                                                               <?php if(!empty($settings['config_recaptcha_in_user_login'])): ?>
                                                               checked
                                                            <?php endif; ?>>

                                                        <label class="form-check-label" for="config_recaptcha_in_user_login"><?php echo e(__('Enable Recaptcha in User Login')); ?></label>
                                                    </div>
                                                    <div class="form-check form-switch mt-3">
                                                        <input class="form-check-input" type="checkbox" role="switch" id="config_recaptcha_in_admin_login" name="config_recaptcha_in_admin_login" value="1"
                                                               <?php if(!empty($settings['config_recaptcha_in_admin_login'])): ?>
                                                               checked
                                                            <?php endif; ?>>

                                                        <label class="form-check-label" for="config_recaptcha_in_admin_login"><?php echo e(__('Enable Recaptcha in Admin Login')); ?></label>
                                                    </div>
                                                    <div class="form-check form-switch mt-3">
                                                        <input class="form-check-input" type="checkbox" role="switch" id="config_recaptcha_in_user_signup" name="config_recaptcha_in_user_signup" value="1"
                                                               <?php if(!empty($settings['config_recaptcha_in_user_signup'])): ?>
                                                               checked
                                                            <?php endif; ?>>

                                                        <label class="form-check-label" for="config_recaptcha_in_user_signup"><?php echo e(__('Enable Recaptcha in Signup Page')); ?></label>
                                                    </div>


                                                <?php endif; ?>

                                                <?php echo csrf_field(); ?>
                                                <button class="btn btn-info float-left mb-0 mt-3"><?php echo e(__('Save')); ?></button>
                                            </div>
                                        </div>


                                    </form>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>


            </div>
        </div>
    <?php endif; ?>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.'.($layout ?? 'primary'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/settings/settings.blade.php ENDPATH**/ ?>