<?php $__env->startSection('content'); ?>

    <div class="">
        <div class="row">

            <div class="col-xl-5 ms-auto mt-xl-0">
                <div class="row">
                    <div class="col-12">
                        <div class="card bg-brown">
                            <div class="card-body p-3">
                                <div class="row">
                                    <div class="">
                                        <p class="text-sm mb-0 text-capitalize font-weight-bold opacity-7"></p>
                                        <h6 class="text-white font-weight-bolder mb-0">
                                            <?php echo e($today->format(config('app.date_time_format'))); ?>

                                        </h6>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mt-4">

                    <?php if(empty($modules) || in_array('goals',$modules)): ?>
                        <div class="col-md-6">
                            <div class="card bg-blue-light">
                                <a href="/goals">
                                    <div class="card-body text-center">
                                        <h1 class="text-info"><span id="status1"><?php echo e($total_goals); ?></span> </h1>
                                        <h6 class="mb-0 text-info font-weight-bolder"><?php echo e(__('Goals')); ?></h6>

                                    </div>

                                </a>

                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if(empty($modules) || in_array('plans',$modules)): ?>
                        <div class="col-md-6 mt-md-0 mt-4">
                            <div class="card bg-purple-light">
                                <a href="/plans">
                                    <div class="card-body  text-center">
                                        <h1 class="text-purple"> <span id="status2" countto="44"><?php echo e($total_plans); ?></span></h1>
                                        <h6 class="mb-0 text-purple font-weight-bolder"><?php echo e(__('Plans')); ?></h6>

                                    </div>
                                </a>
                            </div>
                        </div>


                    <?php endif; ?>


                </div>
                <div class="row mt-4">

                    <?php if(empty($modules) || in_array('notes',$modules)): ?>

                        <div class="col-md-6">
                            <div class="card bg-warning-light">
                                <a href="/notes">
                                    <div class="card-body  text-center">
                                        <h1 class="text-gradient text-warning"><span id="status3" countto="87"><?php echo e($total_notes); ?></span></h1>
                                        <h6 class="mb-0 text-warning font-weight-bolder"><?php echo e(__('Notes')); ?></h6>

                                    </div>

                                </a>

                            </div>
                        </div>


                    <?php endif; ?>


                    <?php if(empty($modules) || in_array('projects',$modules)): ?>

                        <div class="col-md-6 mt-md-0 mt-4">
                            <div class="card bg-success-light">
                                <a href="/projects">
                                    <div class="card-body text-center">
                                        <h1 class="text-success"><span id="status4"><?php echo e($total_projects); ?></span></h1>
                                        <h6 class="mb-0 text-success font-weight-bolder"><?php echo e(__('Projects')); ?></h6>

                                    </div>

                                </a>

                            </div>
                        </div>



                    <?php endif; ?>


                </div>
            </div>

            <?php if(empty($modules) || in_array('to_dos',$modules)): ?>

                <div class="col-xl-7">
                    <div class="card" id="v-pills-tabContent">
                        <div class="tab-pane fade show position-relative active height-400 border-radius-lg" id="cam1" role="tabpanel">
                            <div class="overflow-hidden position-relative border-radius-lg bg-cover h-100">

                                <div class="bg-pink-light position-relative z-index-1 d-flex flex-column h-100 p-3">
                                    <h5 class="text-dark font-weight-bolder mb-4 pt-2"><?php echo e(__('Todays to-do')); ?><span class="float-end"><a  href="/add-task" class="btn btn-outline-dark rounded-circle p-2 mx-2 mb-0" type="button">
                                                <i class="fas fa-plus p-2"></i>
                                            </a></span></h5>


                                    <ul class="list-group   list-group-flush" data-toggle="checklist">
                                        <?php $__currentLoopData = $todos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $todo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>


                                            <div class="checklist-item checklist-item-primary ps-2 ms-3 mb-3">
                                                <div class="d-flex align-items-center">
                                                    <div class="form-check">
                                                        <input class="form-check-input  todo_checkbox" type="checkbox"
                                                               data-id="<?php echo e($todo->id); ?>"

                                                               <?php if($todo->completed): ?> checked <?php endif; ?>

                                                        >
                                                    </div>
                                                    <h6 class="mb-0 text-dark font-weight-bold text-sm"><?php echo e($todo->title); ?></h6>

                                                </div>

                                            </div>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </ul>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            <?php endif; ?>




        </div>

        <?php if(empty($modules) || in_array('projects',$modules)): ?>


            <div class="card mt-4">
                <div class="card-header pb-0 p-3">
                    <div class="d-flex align-items-center">
                        <h6 class="mb-0"><?php echo e(__('Recent Projects')); ?></h6>

                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-items-center mb-0">
                        <thead>
                        <tr>
                            <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">
                                <?php echo e(__('Project Name')); ?>

                            </th>

                            <th class="text-uppercase text-center text-secondary text-xs font-weight-bolder opacity-7">
                                <?php echo e(__('Start Date')); ?>


                            </th>

                            <th class="text-center text-uppercase text-secondary text-xxs font-weight-bolder opacity-7"><?php echo e(__('End Date')); ?></th>

                            <th class="text-uppercase text-center text-secondary text-xs font-weight-bolder opacity-7">
                                <?php echo e(__('Status')); ?>


                            </th>
                            <th></th>

                        </tr>
                        </thead>
                        <tbody>

                        <?php $__currentLoopData = $recent_projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <div class="d-flex px-2 py-1">
                                        <div class="avatar avatar-sm me-3 bg-brown border-radius-md p-2">
                                            <h6 class="text-white"><?php echo e($project->title['0']); ?></h6>
                                        </div>
                                        <a href="/view-project?id=<?php echo e($project->id); ?>" class="d-flex flex-column justify-content-center">
                                            <h6 class="mb-0 text-sm"><?php echo e($project->title); ?></h6>


                                        </a>
                                    </div>
                                </td>


                                <td class="align-middle text-center">
                                    <span class="badge bg-purple-light fw-bolder">                    <?php if(!empty($project->start_date)): ?>
                                            <?php echo e($project->start_date->format(config('app.date_format'))); ?>

                                        <?php endif; ?>

                                    </span>
                                </td>
                                <td class="align-middle text-center">
                                    <span class="badge bg-warning-light font-weight-bold">  <?php if(!empty($project->end_date)): ?>
                                            <?php echo e($project->end_date->format(config('app.date_format'))); ?>

                                        <?php endif; ?>
                                        </span>
                                </td>
                                <td class="align-middle text-center">
                                    <span class="badge bg-info-light fw-bolder"><?php echo e($project->status); ?></span>
                                </td>
                                <td>
                                    <a class="btn btn-link text-dark float-end px-3 mb-0" href="/create-project?id=<?php echo e($project->id); ?>"><i class="fas  fa-pen text-dark me-2" aria-hidden="true"></i><?php echo e(__('Edit')); ?></a>
                                    <a class="btn btn-link text-dark float-end px-3 mb-0" href="/view-project?id=<?php echo e($project->id); ?>"><i class="fas fa-file-alt text-dark me-2" aria-hidden="true"></i><?php echo e(__('View')); ?></a>

                                </td>

                            </tr>



                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>


        <?php endif; ?>

        <div class="row">


            <?php if(empty($modules) || in_array('notes',$modules)): ?>

                <div class="col-xl-7 mt-4">
                    <div class="card" id="v-pills-tabContent">
                        <div class="tab-pane fade show position-relative active height-400 border-radius-lg" id="cam1" role="tabpanel">
                            <div class="overflow-hidden position-relative border-radius-lg bg-cover h-100">

                                <div class="bg-warning-light position-relative z-index-1 d-flex flex-column h-100 p-3">
                                    <h6 class="text-dark font-weight-bolder mb-4 pt-2"><?php echo e(__('Recent Notes')); ?><span class="float-end"><a  href="/add-note" class="btn btn-dark rounded-circle p-2 mx-2 mb-0" type="button">
                                                <i class="fas fa-plus p-2"></i>
                                            </a></span></h6>


                                    <ul class="list-group   list-group-flush" data-toggle="checklist">
                                        <?php $__currentLoopData = $recent_notes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>




                                            <h6 class="mb-2 ms-4 text-dark "><?php echo e($note->title); ?></h6>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </ul>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            <?php endif; ?>

                <div class="col-xl-5 ms-auto mt-xl-0">

                    <div class="row mt-4">


                        <?php if(empty($modules) || in_array('vision_board',$modules)): ?>
                            <div class="col-md-12 mt-md-0 mt-4">
                                <div class="card bg-purple-light">
                                    <a href="/vision-board">
                                        <div class="card-body  text-center">
                                            <h1 class="text-purple"> <span id="status2" countto="44"><?php echo e($total_images); ?></span></h1>
                                            <h6 class="mb-0 text-purple font-weight-bolder"><?php echo e(__('Vision Board Image')); ?></h6>

                                        </div>

                                    </a>

                                </div>
                            </div>


                        <?php endif; ?>


                    </div>
                    <div class="row mt-4">




                        <?php if(empty($modules) || in_array('five_minute_journal',$modules)): ?>

                            <div class="col-md-12 mt-md-0 mt-4">
                                <div class="card bg-blue-light">
                                    <a href="/gratitude">
                                        <div class="card-body text-center">
                                            <h1 class="text-info"><span id="status4"><?php echo e($total_journals); ?></span></h1>
                                            <h6 class="mb-0 text-info font-weight-bolder"><?php echo e(__('Five Minute Journal')); ?></h6>

                                        </div>

                                    </a>

                                </div>
                            </div>



                        <?php endif; ?>


                    </div>
                </div>




        </div>



        <div class="row mt-4">

            <?php if(empty($modules) || in_array('calendar',$modules)): ?>

                <div class="col-lg-5 ms-auto">
                    <div class="card">
                        <div class="card-header pb-0 p-3">
                            <div class="d-flex align-items-center">
                                <h6 class="mb-0"><?php echo e(__('Recent Events')); ?></h6>

                            </div>
                        </div>

                        <div class="card">

                            <div class="card-body border-radius-lg p-3">

                                <?php $__currentLoopData = $recent_events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <div class="d-flex mt-4">
                                        <div>
                                            <div class="icon icon-shape bg-blue-light shadow text-center border-radius-md shadow-none">
                                                <i class="ni ni-bell-55 text-lg text-info  opacity-10" aria-hidden="true"></i>
                                            </div>
                                        </div>
                                        <div class="ms-3">
                                            <div class="numbers">
                                                <h6 class="mb-1 text-dark text-sm"><?php echo e($event->title); ?></h6>

                                                <span class="text-sm"><?php echo e($event->start_date->format(config('app.date_time_format'))); ?>---<span class="text-sm"><?php echo e($event->end_date->format(config('app.date_time_format'))); ?></span></span>




                                            </div>


                                        </div>


                                    </div>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                        </div>
                    </div>
                </div>




            <?php endif; ?>

                <?php if(empty($modules) || in_array('goals',$modules)): ?>

                    <div class="col-md-7 ">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card mb-4">
                                    <div class="card-header pb-0">
                                        <h6><?php echo e(__('Goals')); ?></h6>
                                    </div>
                                    <div class="card-body px-0 pt-0 pb-2">
                                        <div class="table-responsive p-0">
                                            <table class="table align-items-center mb-0">
                                                <thead>
                                                <tr>
                                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7"><?php echo e(__('Name')); ?></th>
                                                    <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7 ps-2"><?php echo e(__('Estimate Date to finish')); ?></th>
                                                    <th class="text-center  text-uppercase text-secondary text-xs font-weight-bolders opacity-7"><?php echo e(__('Completed?')); ?></th>



                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <div class="d-flex px-3">

                                                                <div class="d-flex flex-column justify-content-center">
                                                                    <h6 class="mb-0 "><a href="/set-goal?id=<?php echo e($goal->id); ?>"><?php echo e($goal->name); ?></a></h6>

                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>

                                                            <span class="text-sm font-weight-bold"><?php echo e($goal->date->format(config('app.date_format'))); ?></span>

                                                        </td>

                                                        <td class="text-sm text-center p-3 px-6 ">
                                                            <div class="form-check text-center ">
                                                                <input class="form-check-input goal_checkbox" type="checkbox"
                                                                       data-id="<?php echo e($goal->id); ?>"

                                                                       <?php if($goal->completed): ?> checked <?php endif; ?>

                                                                >

                                                            </div>
                                                        </td>


                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>




                <?php endif; ?>



        </div>



    </div>




<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>

    <script>
        "use strict"
        $(function () {
            $('.todo_checkbox').on('change',function () {
                let that = $(this);
                if(this.checked)
                {
                    $.post('/todos/change-status',{
                        id: that.attr('data-id'),
                        status: 'Completed',
                        _token: '<?php echo e(csrf_token()); ?>',
                    });
                }
                else{
                    $.post('/todos/change-status',{
                        id: that.attr('data-id'),
                        status: 'Not Completed',
                        _token: '<?php echo e(csrf_token()); ?>',
                    });
                }
            });
        });
    </script>
    <script>

        $(function () {
            $('.goal_checkbox').on('change',function () {
                let that = $(this);
                if(this.checked)
                {
                    $.post('/goals/change-status',{
                        id: that.attr('data-id'),
                        status: 'Completed',
                        _token: '<?php echo e(csrf_token()); ?>',
                    });
                }
                else{
                    $.post('/goals/change-status',{
                        id: that.attr('data-id'),
                        status: 'Not Completed',
                        _token: '<?php echo e(csrf_token()); ?>',
                    });
                }
            });
        });
    </script>


<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/focus-saas/resources/views/dashboard.blade.php ENDPATH**/ ?>