<?php $__env->startSection('content'); ?>

    <div class="card">
        <div class="card-header">
            <?php echo e(__('Plan for your dreams/goals')); ?>

        </div>

        <div class="card-body">
            <form action="/save-goal-plan" method="post">
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul class="list-unstyled">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="form-group">
                    <label for="example-text-input" class="form-control-label">
                        <?php echo e(__('Title')); ?>


                    </label><span class="text-danger">*</span>
                    <input class="form-control" name="title" type="text" id="example-text-input"  <?php if(!empty($plan)): ?> value="<?php echo e($plan->title); ?>" <?php endif; ?>>
                </div>
                <div class="form-group">
                    <label for="example-text-input" class="form-control-label">
                        <?php echo e(__('Choose the goal to plan for')); ?>


                    </label><span class="text-danger">*</span>

                    <select class="form-select" aria-label="Default select example" name="goal_id">

                        <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($goal->id); ?>"
                                    <?php if(!empty($plan)): ?>
                                    <?php if($plan->goal_id == $goal->id): ?>
                                    selected
                                <?php endif; ?>
                                <?php endif; ?>
                            ><?php echo e($goal->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="example-date-input" class="form-control-label"><?php echo e(__('Date')); ?></label>
                    <input class="form-control" name="date" id="date"
                           <?php if(!empty($plan)): ?>
                           value="<?php echo e($plan->date); ?>"
                           <?php else: ?>
                           value="<?php echo e(date('Y-m-d')); ?>"
                    <?php endif; ?>">
                </div>
                    <div class="mb-3">
                        <label for="exampleFormControlTextarea1"><?php echo e(__('Write a precise plan')); ?></label><span class="text-danger">*</span>
                        <textarea class="form-control" name="description" id="description" rows="3"><?php if(!empty($plan)): ?><?php echo e($plan->description); ?><?php endif; ?></textarea>
                    </div>

                    <?php if($plan): ?>
                        <input type="hidden" name="id" value="<?php echo e($plan->id); ?>">
                    <?php endif; ?>
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn bg-gradient-secondary">
                    <?php echo e(__('Save')); ?>


                </button>
                <button type="button" class="btn bg-gradient-primary">
                    <?php echo e(__('Close')); ?>


                </button>
            </form>

        </div>

    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

    <script>
        "use strict";
        $(function () {


            flatpickr("#date", {

                dateFormat: "Y-m-d",
            });



        });


    </script>
    <script>
        tinymce.init({
            selector: '#description',

            plugins: 'table,code',


        });
    </script>


<?php $__env->stopSection(); ?>









<?php echo $__env->make('layouts.primary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/sadia/Documents/valet/startup-kit/resources/views/plans/goal-plan.blade.php ENDPATH**/ ?>